<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns="http://www.insophy.cz/inplan/plan/1.x"
	xmlns:oldNs="http://www.insophy.cz/inplan/plan"
	>
  
  <!-- update the namespace -->
  <xsl:template match="/oldNs:plan">
    <xsl:element 
      name="plan" 
      namespace="http://www.insophy.cz/inplan/plan/1.x" >
      <xsl:attribute name="schemaVersion">1.x</xsl:attribute>
      <xsl:apply-templates />
    </xsl:element>    
  </xsl:template>
  
  <!--capture some nodes and change them 
  <xsl:template match="oldNs:gor">
    <xsl:element name="newgor">
    DO_SOME_CHANGES
    <xsl:apply-templates select="*|@*|text()"/>
    </xsl:element>
  </xsl:template>-->
  
  <!-- discard all store activities for actions -->
  <xsl:template match="//oldNs:action/oldNs:store-activities">
  </xsl:template>
  
  <!-- discard all estimate source schedules -->
  <xsl:template match="//oldNs:source-schedule[@type='ESTIMATE']">
  </xsl:template>
  
  <!-- drop type attribute for REAL source schedules-->
  <xsl:template match="//oldNs:source-schedule[@type='REAL']">
    <xsl:element name="source-schedule">
    	<xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
  
  <!-- drop type attribute for ESTIMATE store schedules-->
  <xsl:template match="//oldNs:store-schedule">
    <xsl:element name="store-schedule">
    	<xsl:apply-templates select="*|text()"/>
    </xsl:element>
  </xsl:template>

  <!-- discard all estimate destination schedules -->
  <xsl:template match="//oldNs:destination-schedule[@type='ESTIMATE']">
  </xsl:template>

  <!-- drop type attribute for REAL destination schedules-->
  <xsl:template match="//oldNs:destination-schedule[@type='REAL']">
    <xsl:element name="destination-schedule">
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:apply-templates select="*|text()"/>
    </xsl:element>
  </xsl:template>

  <!-- discard all activities wih said attribute -->
  <xsl:template match="//oldNs:activity[@said]">
  </xsl:template>
  
  
  
  
  <!-- copy the rest -->
  <xsl:template match="@*|text()">
    <xsl:copy>
      <xsl:apply-templates select="@*|text()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="*|@*|text()"/>
    </xsl:element>
  </xsl:template>
  
</xsl:stylesheet> 